<?php

namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Sales\CustomerInvoiceReconciled
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $customer_invoice_id
 * @property string $name
 * @property int|null $reconciled_id
 * @property float|null $currency_value
 * @property float $amount_reconciled
 * @property float $last_balance
 * @property int $number_of_payment
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Sales\CustomerInvoice $customerInvoice
 * @property-read \App\Models\Sales\CustomerInvoice|null $reconciled
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled whereAmountReconciled($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled whereCurrencyValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled whereCustomerInvoiceId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled whereLastBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled whereNumberOfPayment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled whereReconciledId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceReconciled whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class CustomerInvoiceReconciled extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_invoice_reconcileds';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_invoice_id',
        'name',
        'reconciled_id',
        'currency_value',
        'amount_reconciled',
        'last_balance',
        'number_of_payment',
        'sort_order',
        'status'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function customerInvoice()
    {
        return $this->belongsTo(CustomerInvoice::class);
    }

    public function reconciled()
    {
        return $this->belongsTo(CustomerInvoice::class,'reconciled_id','id');
    }
}
