<?php

namespace App\Models\Sales;

use App\Helpers\Helper;
use App\Models\Base\Company;
use App\Models\Catalogs\City;
use App\Models\Catalogs\State;
use App\Models\Catalogs\CfdiUse;
use App\Models\Catalogs\Country;
use App\Models\Catalogs\Project;
use App\Models\Catalogs\Station;
use App\Models\Base\BranchOffice;
use App\Models\Base\DocumentType;
use App\Models\Catalogs\Currency;
use App\Models\Catalogs\Incoterm;
use App\Models\Catalogs\Pediment;
use App\Models\Catalogs\PaymentWay;
use App\Models\Catalogs\PermitType;
use App\Models\Catalogs\TaxRegimen;
use Kyslik\ColumnSortable\Sortable;
use App\Models\Catalogs\PaymentTerm;
use App\Models\Catalogs\StationType;
use App\Models\Catalogs\TrailerType;
use App\Models\Catalogs\CfdiRelation;
use App\Models\Catalogs\OperationType;
use App\Models\Catalogs\PaymentMethod;
use App\Models\Catalogs\TransportPart;
use App\Models\Catalogs\TransportType;
use App\Models\Catalogs\TransferReason;
use Illuminate\Database\Eloquent\Model;
use App\Models\Catalogs\MeasurePackaging;
use App\Models\Catalogs\SettingTransport;
use Hyn\Tenancy\Traits\UsesTenantConnection;


class CustomerInvoiceTransfer extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_invoice_transfers';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_invoice_id',
        'transport_int',
        'distance_traveled',
        'in_out_product',
        'in_out_country_id',
        'transport_type_id',
        'trans_transport_type_id',
        'source_station_type_id',
        'source_distance_traveled',
        'source_id',
        'source_taxid',
        'source_name',
        'source_tr_country_id',
        'source_numid',
        'source_station_id',
        'source_station',
        'source_traffic_navigation',
        'source_date',
        'source_address_1',
        'source_address_2',
        'source_address_3',
        'source_address_4',
        'source_address_5',
        'source_address_6',
        'source_city_id',
        'source_state_id',
        'source_country_id',
        'source_postcode',
        'destination_station_type_id',
        'destination_distance_traveled',
        'destination_id',
        'destination_taxid',
        'destination_name',
        'destination_tr_country_id',
        'destination_numid',
        'destination_station_id',
        'destination_station',
        'destination_traffic_navigation',
        'destination_date',
        'destination_address_1',
        'destination_address_2',
        'destination_address_3',
        'destination_address_4',
        'destination_address_5',
        'destination_address_6',
        'destination_city_id',
        'destination_state_id',
        'destination_country_id',
        'destination_postcode',
        'operator_taxid',
        'operator_license',
        'operator_name',
        'operator_tr_country_id',
        'operator_numid',
        'gross_weight',
        'measure_packaging_id',
        'net_weight',
        'appraisal_fee',
        'permit_type_id',
        'permit_number',
        'setting_transport_id',
        'vehicle',
        'vehicle_number',
        'name_insurer',
        'policy_number',
        'name_insurer2',
        'policy_number2',
        'name_insurer3',
        'policy_number3',
        'insurance_value',
        'trailer_type_id_1',
        'trailer_number_1',
        'trailer_type_id_2',
        'trailer_number_2',
        'trailer_type_id_3',
        'trailer_number_3',
        'trailer_type_id_4',
        'trailer_number_4',
        'trailer_type_id_5',
        'trailer_number_5',
        'owner_taxid',
        'owner_name',
        'owner_tr_country_id',
        'owner_numid',
        'owner_transport_part_id',
        'owner_address_1',
        'owner_address_2',
        'owner_address_3',
        'owner_address_4',
        'owner_address_5',
        'owner_address_6',
        'owner_city_id',
        'owner_state_id',
        'owner_country_id',
        'owner_postcode',
        'lessee_taxid',
        'lessee_name',
        'lessee_tr_country_id',
        'lessee_numid',
        'lessee_transport_part_id',
        'lessee_address_1',
        'lessee_address_2',
        'lessee_address_3',
        'lessee_address_4',
        'lessee_address_5',
        'lessee_address_6',
        'lessee_city_id',
        'lessee_state_id',
        'lessee_country_id',
        'lessee_postcode',
        'notified_taxid',
        'notified_name',
        'notified_tr_country_id',
        'notified_numid',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = [
    ];

    public function customerInvoice()
    {
        return $this->belongsTo(CustomerInvoice::class);
    }
    public function inOutCountry()
    {
        return $this->belongsTo(Country::class, 'in_out_country_id');
    }
    public function transportType()
    {
        return $this->belongsTo(TransportType::class);
    }
    public function transTransportType()
    {
        return $this->belongsTo(TransportType::class);
    }
    public function sourceStationType()
    {
        return $this->belongsTo(StationType::class, 'source_station_type_id');
    }
    public function sourceTrCountry()
    {
        return $this->belongsTo(Country::class, 'source_tr_country_id');
    }
    public function sourceStation()
    {
        return $this->belongsTo(Station::class, 'source_station_id');
    }
    public function sourceCity()
    {
        return $this->belongsTo(City::class, 'source_city_id');
    }
    public function sourceState()
    {
        return $this->belongsTo(State::class, 'source_state_id');
    }
    public function sourceCountry()
    {
        return $this->belongsTo(Country::class, 'source_country_id');
    }
    public function destinationStationType()
    {
        return $this->belongsTo(StationType::class, 'destination_station_type_id');
    }
    public function destinationTrCountry()
    {
        return $this->belongsTo(Country::class, 'destination_tr_country_id');
    }
    public function destinationStation()
    {
        return $this->belongsTo(Station::class, 'destination_station_id');
    }
    public function destinationCity()
    {
        return $this->belongsTo(City::class, 'destination_city_id');
    }
    public function destinationState()
    {
        return $this->belongsTo(State::class, 'destination_state_id');
    }
    public function destinationCountry()
    {
        return $this->belongsTo(Country::class, 'destination_country_id');
    }
    public function operatorTrCountry()
    {
        return $this->belongsTo(Country::class, 'operator_tr_country_id');
    }
    public function measurePackaging()
    {
        return $this->belongsTo(MeasurePackaging::class);
    }
    public function permitType()
    {
        return $this->belongsTo(PermitType::class);
    }
    public function settingTransport()
    {
        return $this->belongsTo(SettingTransport::class);
    }
    public function trailerType1()
    {
        return $this->belongsTo(TrailerType::class, 'trailer_type_id_1');
    }
    public function trailerType2()
    {
        return $this->belongsTo(TrailerType::class, 'trailer_type_id_2');
    }
    public function trailerType3()
    {
        return $this->belongsTo(TrailerType::class, 'trailer_type_id_3');
    }
    public function trailerType4()
    {
        return $this->belongsTo(TrailerType::class, 'trailer_type_id_4');
    }
    public function trailerType5()
    {
        return $this->belongsTo(TrailerType::class, 'trailer_type_id_5');
    }
    public function ownerTrCountry()
    {
        return $this->belongsTo(Country::class, 'owner_tr_country_id');
    }
    public function ownerTransportPart()
    {
        return $this->belongsTo(TransportPart::class, 'owner_transport_part_id');
    }
    public function ownerCity()
    {
        return $this->belongsTo(City::class, 'owner_city_id');
    }
    public function ownerState()
    {
        return $this->belongsTo(State::class, 'owner_state_id');
    }
    public function ownerCountry()
    {
        return $this->belongsTo(Country::class, 'owner_country_id');
    }
    public function lesseeTrCountry()
    {
        return $this->belongsTo(Country::class, 'lessee_tr_country_id');
    }
    public function lesseeTransportPart()
    {
        return $this->belongsTo(TransportPart::class, 'lessee_transport_part_id');
    }
    public function lesseeCity()
    {
        return $this->belongsTo(City::class, 'lessee_city_id');
    }
    public function lesseeState()
    {
        return $this->belongsTo(State::class, 'lessee_state_id');
    }
    public function lesseeCountry()
    {
        return $this->belongsTo(Country::class, 'lessee_country_id');
    }
    public function notifiedTrCountry()
    {
        return $this->belongsTo(Country::class, 'notified_tr_country_id');
    }
}
