<?php

namespace App\Models\Sales;

use App\Models\Base\Pac;
use App\Models\Catalogs\ReasonCancellation;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Sales\CustomerPaymentCfdi
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $customer_payment_id
 * @property string $name
 * @property int|null $pac_id
 * @property string|null $cfdi_version
 * @property string|null $uuid
 * @property string|null $date
 * @property string|null $file_xml
 * @property string|null $file_xml_pac
 * @property string|null $cancel_date
 * @property string|null $cancel_response
 * @property string|null $cancel_state
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Sales\CustomerPayment $customerPayment
 * @property-read \App\Models\Base\Pac|null $pac
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereCancelDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereCancelResponse($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereCancelState($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereCfdiVersion($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereCustomerPaymentId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereFileXml($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereFileXmlPac($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi wherePacId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereUpdatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentCfdi whereUuid($value)
 * @mixin \Eloquent
 */
class CustomerPaymentCfdi extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_payment_cfdis';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_payment_id',
        'name',
        'pac_id',
        'cfdi_version',
        'uuid',
        'date',
        'file_xml',
        'file_xml_pac',
        'cancel_date',
        'cancel_response',
        'cancel_state',
        'status',
        'reason_cancellation_id',
        'reason_cancellation_uuid'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('uuid', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function customerPayment()
    {
        return $this->belongsTo(CustomerPayment::class);
    }

    public function pac()
    {
        return $this->belongsTo(Pac::class);
    }

    public function reasonCancellation()
    {
        return $this->belongsTo(ReasonCancellation::class);
    }
}
