<?php

namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Sales\CustomerPaymentReconciled
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $customer_payment_id
 * @property string $name
 * @property int|null $reconciled_id
 * @property float|null $currency_value
 * @property float $amount_reconciled
 * @property float $last_balance
 * @property int $number_of_payment
 * @property int $sort_order
 * @property bool $status
 * @property string|null $uuid_related
 * @property string|null $serie_related
 * @property int|null $folio_related
 * @property string|null $currency_code_related
 * @property string|null $payment_method_code_related
 * @property float $current_balance
 * @property-read \App\Models\Sales\CustomerPayment $customerPayment
 * @property-read \App\Models\Sales\CustomerInvoice|null $reconciled
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereAmountReconciled($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereCurrencyCodeRelated($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereCurrencyValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereCurrentBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereCustomerPaymentId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereFolioRelated($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereLastBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereNumberOfPayment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled wherePaymentMethodCodeRelated($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereReconciledId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereSerieRelated($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereUpdatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentReconciled whereUuidRelated($value)
 * @mixin \Eloquent
 */
class CustomerPaymentReconciled extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_payment_reconcileds';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_payment_id',
        'name',
        'reconciled_id',
        'currency_value',
        'amount_reconciled',
        'last_balance',
        'number_of_payment',
        'sort_order',
        'status',
        'uuid_related',
        'serie_related',
        'folio_related',
        'currency_code_related',
        'payment_method_code_related',
        'current_balance',
        'tax_id_1',
        'amount_base_1',
        'tax_id_2',
        'amount_base_2',
        'tax_id_3',
        'amount_base_3',
        'tax_id_4',
        'amount_base_4',
        'tax_id_5',
        'amount_base_5',
        'amount_total',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function customerPayment()
    {
        return $this->belongsTo(CustomerPayment::class);
    }

    public function reconciled()
    {
        return $this->belongsTo(CustomerInvoice::class,'reconciled_id','id');
    }

}
