<?php

namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Sales\CustomerPaymentRelation
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $customer_payment_id
 * @property int|null $relation_id
 * @property int $sort_order
 * @property bool $status
 * @property string|null $uuid_related
 * @property-read \App\Models\Sales\CustomerPayment $customerPayment
 * @property-read \App\Models\Sales\CustomerPayment|null $relation
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation whereCustomerPaymentId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation whereRelationId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation whereUpdatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerPaymentRelation whereUuidRelated($value)
 * @mixin \Eloquent
 */
class CustomerPaymentRelation extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_payment_relations';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_payment_id',
        'relation_id',
        'sort_order',
        'status',
        'uuid_related'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function customerPayment()
    {
        return $this->belongsTo(CustomerPayment::class);
    }

    public function relation()
    {
        return $this->belongsTo(CustomerPayment::class,'relation_id','id');
    }
}
