<?php

namespace App\Models\Sales;

use App\Models\Catalogs\Product;
use App\Models\Catalogs\SatProduct;
use App\Models\Catalogs\Tax;
use App\Models\Catalogs\UnitMeasure;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Sales\CustomerQuotationLine
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $customer_quotation_id
 * @property string $name
 * @property int|null $product_id
 * @property int|null $sat_product_id
 * @property int|null $unit_measure_id
 * @property float $quantity
 * @property float $price_unit
 * @property float $discount
 * @property float $price_reduce
 * @property float $amount_discount
 * @property float $amount_untaxed
 * @property float $amount_tax
 * @property float $amount_tax_ret
 * @property float $amount_total
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Sales\CustomerQuotation $customerQuotation
 * @property-read \App\Models\Catalogs\Product|null $product
 * @property-read \App\Models\Catalogs\SatProduct|null $satProduct
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Catalogs\Tax[] $taxes
 * @property-read \App\Models\Catalogs\UnitMeasure|null $unitMeasure
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereAmountDiscount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereAmountTax($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereAmountTaxRet($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereAmountTotal($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereAmountUntaxed($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereCustomerQuotationId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereDiscount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine wherePriceReduce($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine wherePriceUnit($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereProductId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereQuantity($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereSatProductId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereUnitMeasureId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationLine whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class CustomerQuotationLine extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_quotation_lines';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_quotation_id',
        'name',
        'product_id',
        'sat_product_id',
        'unit_measure_id',
        'quantity',
        'price_unit',
        'discount',
        'price_reduce',
        'amount_discount',
        'amount_untaxed',
        'amount_tax',
        'amount_tax_ret',
        'amount_total',
        'sort_order',
        'status',
        'quota_ieps',
        'tax_object'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function customerQuotation()
    {
        return $this->belongsTo(CustomerQuotation::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function unitMeasure()
    {
        return $this->belongsTo(UnitMeasure::class);
    }

    public function satProduct()
    {
        return $this->belongsTo(SatProduct::class);
    }

    public function taxes()
    {
        return $this->belongsToMany(Tax::class,'customer_quotation_line_taxes');
    }
}
