<?php

namespace App\Models\Sales;

use App\Models\Catalogs\Tax;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Sales\CustomerQuotationTax
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $customer_quotation_id
 * @property string $name
 * @property int $tax_id
 * @property float|null $amount_base
 * @property float|null $amount_tax
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Sales\CustomerQuotation $customerQuotation
 * @property-read \App\Models\Catalogs\Tax $tax
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax whereAmountBase($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax whereAmountTax($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax whereCustomerQuotationId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax whereTaxId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerQuotationTax whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class CustomerQuotationTax extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_quotation_taxes';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_quotation_id',
        'name',
        'tax_id',
        'amount_base',
        'amount_tax',
        'sort_order',
        'status'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function customerQuotation()
    {
        return $this->belongsTo(CustomerQuotation::class);
    }

    public function tax()
    {
        return $this->belongsTo(Tax::class);
    }
}
