<?php

namespace App\Models\Sales;

use App\Models\Catalogs\Product;
use App\Models\Catalogs\SatProduct;
use App\Models\Catalogs\Tax;
use App\Models\Catalogs\UnitMeasure;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Sales\CustomerRemissionLine
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $customer_remission_id
 * @property string $name
 * @property int|null $product_id
 * @property int|null $sat_product_id
 * @property int|null $unit_measure_id
 * @property float $quantity
 * @property float $price_unit
 * @property float $discount
 * @property float $price_reduce
 * @property float $amount_discount
 * @property float $amount_untaxed
 * @property float $amount_tax
 * @property float $amount_tax_ret
 * @property float $amount_total
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Sales\CustomerRemission $customerRemission
 * @property-read \App\Models\Catalogs\Product|null $product
 * @property-read \App\Models\Catalogs\SatProduct|null $satProduct
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Catalogs\Tax[] $taxes
 * @property-read \App\Models\Catalogs\UnitMeasure|null $unitMeasure
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereAmountDiscount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereAmountTax($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereAmountTaxRet($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereAmountTotal($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereAmountUntaxed($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereCustomerRemissionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereDiscount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine wherePriceReduce($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine wherePriceUnit($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereProductId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereQuantity($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereSatProductId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereUnitMeasureId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionLine whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class CustomerRemissionLine extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_remission_lines';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_remission_id',
        'name',
        'product_id',
        'sat_product_id',
        'unit_measure_id',
        'quantity',
        'price_unit',
        'discount',
        'price_reduce',
        'amount_discount',
        'amount_untaxed',
        'amount_tax',
        'amount_tax_ret',
        'amount_total',
        'sort_order',
        'status',
        'quota_ieps',
        'tax_object'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function customerRemission()
    {
        return $this->belongsTo(CustomerRemission::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function unitMeasure()
    {
        return $this->belongsTo(UnitMeasure::class);
    }

    public function satProduct()
    {
        return $this->belongsTo(SatProduct::class);
    }

    public function taxes()
    {
        return $this->belongsToMany(Tax::class,'customer_remission_line_taxes');
    }
}
