<?php

namespace App\Models\Sales;

use App\Models\Catalogs\Tax;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Sales\CustomerRemissionTax
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $customer_remission_id
 * @property string $name
 * @property int $tax_id
 * @property float|null $amount_base
 * @property float|null $amount_tax
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Sales\CustomerRemission $customerRemission
 * @property-read \App\Models\Catalogs\Tax $tax
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax whereAmountBase($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax whereAmountTax($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax whereCustomerRemissionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax whereTaxId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerRemissionTax whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class CustomerRemissionTax extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_remission_taxes';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_remission_id',
        'name',
        'tax_id',
        'amount_base',
        'amount_tax',
        'sort_order',
        'status'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function customerRemission()
    {
        return $this->belongsTo(CustomerRemission::class);
    }

    public function tax()
    {
        return $this->belongsTo(Tax::class);
    }
}
