<?php

namespace App\Models\Sales;

use App\Helpers\Helper;
use App\Models\Base\Company;
use App\Models\Catalogs\CfdiUse;
use App\Models\Catalogs\Project;
use App\Models\Base\BranchOffice;
use App\Models\Catalogs\Currency;
use App\Models\Catalogs\Incoterm;
use App\Models\Catalogs\Pediment;
use App\Models\Catalogs\PaymentWay;
use App\Models\Catalogs\TaxRegimen;
use Kyslik\ColumnSortable\Sortable;
use App\Models\Catalogs\PaymentTerm;
use App\Models\Catalogs\OperationType;
use App\Models\Catalogs\PaymentMethod;
use App\Models\Catalogs\TransferReason;
use Illuminate\Database\Eloquent\Model;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Sales\RecurringCustomerInvoice
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string|null $name
 * @property string|null $date_start
 * @property string|null $date_end
 * @property string|null $date_last
 * @property string|null $date_next
 * @property string|null $frequency
 * @property bool $mail_sent
 * @property string|null $reference
 * @property int|null $customer_id
 * @property int|null $branch_office_id
 * @property int|null $payment_term_id
 * @property int|null $payment_way_id
 * @property int|null $payment_method_id
 * @property int|null $cfdi_use_id
 * @property int|null $salesperson_id
 * @property int|null $currency_id
 * @property float $currency_value
 * @property float $amount_discount
 * @property float $amount_untaxed
 * @property float $amount_tax
 * @property float $amount_tax_ret
 * @property float $amount_total
 * @property string|null $comment
 * @property int $sort_order
 * @property bool $status
 * @property string|null $confirmacion
 * @property string|null $date_delivery
 * @property string|null $source
 * @property string|null $source_name
 * @property string|null $source_taxid
 * @property string|null $source_address
 * @property string|null $source_delivery_on
 * @property string|null $destination
 * @property string|null $destination_name
 * @property string|null $destination_taxid
 * @property string|null $destination_address
 * @property string|null $destination_delivery_on
 * @property float $valid_amount
 * @property bool $dangerous_material
 * @property string|null $compensation
 * @property string|null $retainer_name
 * @property string|null $retainer_taxid
 * @property string|null $driver
 * @property string|null $vehicle
 * @property string|null $vehicle_number
 * @property string|null $vehicle_counter
 * @property string|null $cfdi_type2
 * @property string|null $document_type2
 * @property int|null $company_id
 * @property int|null $transfer_reason_id
 * @property int|null $operation_type_id
 * @property int|null $pediment_id
 * @property string|null $origin_certificate
 * @property string|null $number_origin_certificate
 * @property string|null $reliable_exporter_number
 * @property int|null $incoterm_id
 * @property string|null $subdivision
 * @property string|null $comment_foreign_trade
 * @property float $exchange_rate_usd
 * @property float $amount_total_usd
 * @property string|null $title
 * @property int|null $project_id
 * @property string|null $date_process
 * @property string|null $status_process
 * @property-read \App\Models\Base\BranchOffice|null $branchOffice
 * @property-read \App\Models\Catalogs\CfdiUse|null $cfdiUse
 * @property-read \App\Models\Base\Company|null $company
 * @property-read \App\Models\Catalogs\Currency|null $currency
 * @property-read \App\Models\Sales\Customer|null $customer
 * @property-read mixed $frequency_name
 * @property-read \App\Models\Catalogs\Incoterm|null $incoterm
 * @property-read \App\Models\Catalogs\OperationType|null $operationType
 * @property-read \App\Models\Catalogs\PaymentMethod|null $paymentMethod
 * @property-read \App\Models\Catalogs\PaymentTerm|null $paymentTerm
 * @property-read \App\Models\Catalogs\PaymentWay|null $paymentWay
 * @property-read \App\Models\Catalogs\Pediment|null $pediment
 * @property-read \App\Models\Catalogs\Project|null $project
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer[] $recurringCustomerActiveInvoiceLineTransfers
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Sales\RecurringCustomerInvoiceLine[] $recurringCustomerActiveInvoiceLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Sales\RecurringCustomerInvoiceLine[] $recurringCustomerInvoiceLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Sales\RecurringCustomerInvoiceTax[] $recurringCustomerInvoiceTaxes
 * @property-read \App\Models\Sales\Salesperson|null $salesperson
 * @property-read \App\Models\Catalogs\TransferReason|null $transferReason
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereAmountDiscount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereAmountTax($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereAmountTaxRet($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereAmountTotal($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereAmountTotalUsd($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereAmountUntaxed($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereBranchOfficeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereCfdiType2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereCfdiUseId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereComment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereCommentForeignTrade($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereCompensation($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereConfirmacion($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereCurrencyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereCurrencyValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereDangerousMaterial($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereDateDelivery($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereDateEnd($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereDateLast($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereDateNext($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereDateProcess($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereDateStart($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereDestination($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereDestinationAddress($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereDestinationDeliveryOn($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereDestinationName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereDestinationTaxid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereDocumentType2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereDriver($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereExchangeRateUsd($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereFrequency($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereIncotermId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereMailSent($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereNumberOriginCertificate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereOperationTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereOriginCertificate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice wherePaymentMethodId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice wherePaymentTermId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice wherePaymentWayId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice wherePedimentId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereProjectId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereReference($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereReliableExporterNumber($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereRetainerName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereRetainerTaxid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereSalespersonId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereSource($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereSourceAddress($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereSourceDeliveryOn($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereSourceName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereSourceTaxid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereStatusProcess($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereSubdivision($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereTitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereTransferReasonId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereUpdatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereValidAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereVehicle($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereVehicleCounter($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoice whereVehicleNumber($value)
 * @mixin \Eloquent
 */
class RecurringCustomerInvoice extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'recurring_customer_invoices';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'date_start',
        'date_end',
        'date_last',
        'date_next',
        'frequency',
        'mail_sent',
        'reference',
        'customer_id',
        'branch_office_id',
        'payment_term_id',
        'payment_way_id',
        'payment_method_id',
        'cfdi_use_id',
        'salesperson_id',
        'currency_id',
        'currency_value',
        'amount_discount',
        'amount_untaxed',
        'amount_tax',
        'amount_tax_ret',
        'amount_total',
        'comment',
        'sort_order',
        'status',
        'confirmacion',
        'date_delivery',
        'source',
        'source_name',
        'source_taxid',
        'source_address',
        'source_delivery_on',
        'destination',
        'destination_name',
        'destination_taxid',
        'destination_address',
        'destination_delivery_on',
        'valid_amount',
        'dangerous_material',
        'compensation',
        'retainer_name',
        'retainer_taxid',
        'driver',
        'vehicle',
        'vehicle_number',
        'vehicle_counter',
        'cfdi_type2',
        'document_type2',
        'company_id',
        'transfer_reason_id',
        'operation_type_id',
        'pediment_id',
        'origin_certificate',
        'number_origin_certificate',
        'reliable_exporter_number',
        'incoterm_id',
        'subdivision',
        'comment_foreign_trade',
        'exchange_rate_usd',
        'amount_total_usd',
        'title',
        'project_id',
        'date_process',
        'status_process',
        'tax_regimen_id',
        'tax_regimen_customer_id',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = [
        'name',
        'date_start',
        'date_end',
        'date_last',
        'date_next',
        'amount_untaxed',
        'amount_total',
        'balance',
        'mail_sent',
        'sort_order',
        'status',
        'origin'
    ];

    public function scopeFilter($query, array $input = [])
    {
        $query->where(function ($query) {
            $query->where('recurring_customer_invoices.company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        })->where(function($query) use ($input) {
            if (!empty($input['filter_search'])) {
                $search = $input['filter_search'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            }
            if (!empty($input['filter_name'])) {
                $name = $input['filter_name'];
                $query->where('name', 'like', '%' . str_replace(' ', '%%', $name) . '%');
            }
            if (!empty($input['filter_payment_way_id'])) {
                $payment_way_id = $input['filter_payment_way_id'];
                $query->where('payment_way_id', '=', $payment_way_id);
            }
            if (!empty($input['filter_customer_id'])) {
                $customer_id = $input['filter_customer_id'];
                $query->where('customer_id', '=', $customer_id);
            }
            if (!empty($input['filter_currency_id'])) {
                $currency_id = $input['filter_currency_id'];
                $query->where('currency_id', '=', $currency_id);
            }
            if (!empty($input['filter_branch_office_id'])) {
                $branch_office_id = $input['filter_branch_office_id'];
                $query->where('branch_office_id', '=', $branch_office_id);
            }
            if (!empty($input['filter_salesperson_id'])) {
                $salesperson_id = $input['filter_salesperson_id'];
                $query->where('salesperson_id', '=', $salesperson_id);
            }
            if (isset($input['filter_status']) && in_array($input['filter_status'],['0','1'])) {
                $status = $input['filter_status'];
                $query->where('status', '=', $status);
            }
        });

        return $query;
    }

    public function getFrequencyNameAttribute(){
        $frequencies = config('app.frequencies');
        return isset($frequencies[$this->frequency]) ? $frequencies[$this->frequency] : '' ;
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function branchOffice()
    {
        return $this->belongsTo(BranchOffice::class);
    }

    public function paymentTerm()
    {
        return $this->belongsTo(PaymentTerm::class);
    }

    public function paymentWay()
    {
        return $this->belongsTo(PaymentWay::class);
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class);
    }

    public function cfdiUse()
    {
        return $this->belongsTo(CfdiUse::class);
    }

    public function salesperson()
    {
        return $this->belongsTo(Salesperson::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function recurringCustomerInvoiceLines()
    {
        return $this->hasMany(RecurringCustomerInvoiceLine::class);
    }

    public function recurringCustomerActiveInvoiceLines()
    {
        return $this->hasMany(RecurringCustomerInvoiceLine::class)->where('status','=','1');
    }

    public function recurringCustomerActiveInvoiceLineTransfers()
    {
        return $this->hasMany(RecurringCustomerInvoiceLineTransfer::class)->where('status','=','1');
    }

    public function recurringCustomerInvoiceTaxes()
    {
        return $this->hasMany(RecurringCustomerInvoiceTax::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function transferReason()
    {
        return $this->belongsTo(TransferReason::class);
    }

    public function operationType()
    {
        return $this->belongsTo(OperationType::class);
    }

    public function pediment()
    {
        return $this->belongsTo(Pediment::class);
    }

    public function incoterm()
    {
        return $this->belongsTo(Incoterm::class);
    }

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function taxRegimen()
    {
        return $this->belongsTo(TaxRegimen::class);
    }

    public function taxRegimenCustomer()
    {
        return $this->belongsTo(TaxRegimen::class, 'tax_regimen_customer_id');
    }
}
