<?php

namespace App\Models\Sales;

use App\Models\Catalogs\Product;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Sales\RecurringCustomerInvoiceLineTransfer
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $recurring_customer_invoice_id
 * @property string $name
 * @property int|null $product_id
 * @property string|null $weight
 * @property float $m3
 * @property float $liters
 * @property string|null $packaging
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Catalogs\Product|null $product
 * @property-read \App\Models\Sales\RecurringCustomerInvoice $recurringCustomerInvoice
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer whereLiters($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer whereM3($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer wherePackaging($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer whereProductId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer whereRecurringCustomerInvoiceId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer whereUpdatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceLineTransfer whereWeight($value)
 * @mixin \Eloquent
 */
class RecurringCustomerInvoiceLineTransfer extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'recurring_customer_invoice_line_transfers';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'recurring_customer_invoice_id',
        'name',
        'product_id',
        'weight',
        'm3',
        'liters',
        'packaging',
        'sort_order',
        'status'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function recurringCustomerInvoice()
    {
        return $this->belongsTo(RecurringCustomerInvoice::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
