<?php

namespace App\Models\Sales;

use App\Models\Catalogs\Tax;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Sales\RecurringCustomerInvoiceTax
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $recurring_customer_invoice_id
 * @property string $name
 * @property int $tax_id
 * @property float|null $amount_base
 * @property float|null $amount_tax
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Sales\RecurringCustomerInvoice $recurringCustomerInvoice
 * @property-read \App\Models\Catalogs\Tax $tax
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax whereAmountBase($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax whereAmountTax($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax whereRecurringCustomerInvoiceId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax whereTaxId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\RecurringCustomerInvoiceTax whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class RecurringCustomerInvoiceTax extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'recurring_customer_invoice_taxes';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'recurring_customer_invoice_id',
        'name',
        'tax_id',
        'amount_base',
        'amount_tax',
        'sort_order',
        'status'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function recurringCustomerInvoice()
    {
        return $this->belongsTo(RecurringCustomerInvoice::class);
    }

    public function tax()
    {
        return $this->belongsTo(Tax::class);
    }
}
