<?php

namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Sales\Salesperson
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string $first_name
 * @property string $last_name
 * @property string $email
 * @property string|null $phone
 * @property string|null $phone_mobile
 * @property float $comission_percent
 * @property int $sort_order
 * @property bool $status
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson whereComissionPercent($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson whereFirstName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson whereLastName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson wherePhone($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson wherePhoneMobile($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Salesperson whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class Salesperson extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'salespersons';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'email',
        'phone',
        'phone_mobile',
        'comission_percent',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = [
        'name',
        'first_name',
        'last_name',
        'email',
        'phone',
        'phone_mobile',
        'comission_percent',
        'sort_order',
        'status'
    ];

    /**
     * Filtros generales
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('email', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('phone', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('phone_mobile', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }
}
