<?php

namespace App\Models\Shop;

use App\Models\Catalogs\Tax;
use Hyn\Tenancy\Traits\UsesSystemConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Shop\ShopProduct
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $code
 * @property string|null $slug
 * @property string|null $description
 * @property string|null $image
 * @property float $price
 * @property int $quantity_folio
 * @property bool $top
 * @property int $sort_order
 * @property bool $status
 * @property float $price_distributor
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Shop\ShopTax[] $taxes
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct shopAll()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct whereImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct wherePrice($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct wherePriceDistributor($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct whereQuantityFolio($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct whereSlug($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct whereTop($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopProduct whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class ShopProduct extends Model
{
    use Sortable,UsesSystemConnection;

    protected $table = 'shop_products';

    const PATH_IMAGES = 'images/shop_products';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'code',
        'slug',
        'description',
        'image',
        'price',
        'quantity_folio',
        'top',
        'sort_order',
        'status',
        'price_distributor',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','code','slug','description','price','quantity_folio', 'top', 'sort_order', 'status','price_distributor',];

    /**
     * @return string
     */
    public function pathImage(){
        return '/app-images/' . self::PATH_IMAGES . '/' . $this->image;
    }

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('slug', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('description', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function scopeShopAll($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');
        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function taxes()
    {
        return $this->belongsToMany(ShopTax::class,'shop_product_taxes','shop_product_id','tax_id');
    }
}
