<?php

namespace App\Models\Shop;

use Hyn\Tenancy\Traits\UsesSystemConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Shop\ShopTax
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string $code
 * @property float $rate
 * @property string $factor
 * @property int $sort_order
 * @property bool $status
 * @property-read mixed $name_sat
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax whereFactor($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax whereRate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Shop\ShopTax whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class ShopTax extends Model
{
    const TASA = 'Tasa';
    const CUOTA = 'Cuota';
    const EXENTO = 'Exento';

    const ISR = '001';
    const IVA = '002';
    const IEPS = '003';

    const TRASLADO = 'T';
    const RETENCION = 'R';

    Use Sortable,UsesSystemConnection;

    protected $table = 'shop_taxes';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid', 'updated_uid', 'name', 'code', 'rate', 'factor', 'sort_order', 'status', 'local_taxes', 'type'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'code', 'rate', 'factor', 'sort_order', 'status', 'local_taxes', 'type'];

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('factor', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function factorHuman($factor){
        $str = '';
        if($factor == self::TASA){
            $str = __('catalogs/tax.text_factor_tasa');
        }elseif($factor == self::CUOTA){
            $str = __('catalogs/tax.text_factor_cuota');
        }elseif($factor == self::EXENTO){
            $str = __('catalogs/tax.text_factor_exento');
        }
        return $str;
    }

    public function codeHuman($code){
        $str = '';
        if($code == self::ISR){
            $str = __('catalogs/tax.text_code_isr');
        }elseif($code == self::IVA){
            $str = __('catalogs/tax.text_code_iva');
        }elseif($code == self::IEPS){
            $str = __('catalogs/tax.text_code_ieps');
        }
        return $str;
    }

    public function typeHuman($type){
        $str = '';
        if($type == self::TRASLADO){
            $str = __('catalogs/tax.text_type_traslado');
        }elseif($type == self::RETENCION){
            $str = __('catalogs/tax.text_type_retencion');
        }
        return $str;
    }

    public function getNameSatAttribute()
    {
        return '[' . $this->code . '] ' . $this->name;
    }
}
