<?php

namespace App\Models\System;

use App\Models\Auth\User;
use Hyn\Tenancy\Models\Hostname;
use Hyn\Tenancy\Models\Website;
use Hyn\Tenancy\Traits\UsesSystemConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\System\SysCustomer
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $taxid
 * @property string|null $email
 * @property string|null $password
 * @property string|null $phone
 * @property string|null $record
 * @property string|null $domain
 * @property string|null $fqdn
 * @property int|null $hostname_id
 * @property int|null $website_id
 * @property int $sort_order
 * @property bool $status
 * @property string|null $first_name
 * @property string|null $last_name
 * @property int|null $distributor_id
 * @property-read \App\Models\Auth\User|null $distributor
 * @property-read mixed $description_select2
 * @property-read mixed $text_select2
 * @property-read \Hyn\Tenancy\Models\Hostname|null $hostname
 * @property-read \Hyn\Tenancy\Models\Website|null $website
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer userDistributor()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereDistributorId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereDomain($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereFirstName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereFqdn($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereHostnameId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereLastName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer wherePassword($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer wherePhone($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereRecord($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereTaxid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereUpdatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereWebsiteId($value)
 * @mixin \Eloquent
 * @property string|null $name_user
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysCustomer whereNameUser($value)
 */
class SysCustomer extends Model
{
    use Sortable,UsesSystemConnection;

    protected $table = 'sys_customers';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'taxid',
        'email',
        'password',
        'phone',
        'record',
        'domain',
        'fqdn',
        'hostname_id',
        'website_id',
        'sort_order',
        'status',
        'name_user',
        'distributor_id',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['created_at','name','taxid','email','phone','record','domain','fqdn', 'sort_order', 'status','name_user','distributor_id'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('taxid', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('name_user', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('email', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('phone', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhereHas('hostname', function ($q) use ($search) {
                $q->where('hostnames.fqdn', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            });
            $query->orWhereHas('website', function ($q) use ($search) {
                $q->where('websites.uuid', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            });
            $query->orWhereHas('distributor', function ($q) use ($search) {
                $q->where('users.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            });
        }

        if (!empty($input['filter_search_select2'])) {
            $search = $input['filter_search_select2'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('taxid', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('email', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Solo registros activos
     *
     * @param $query
     * @return mixed
     */
    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function scopeUserDistributor($query)
    {
        $query->where('distributor_id','=',\Auth::user()->id);
        return $query;
    }

    public function getTextSelect2Attribute()
    {
        return $this->name;
    }

    public function getDescriptionSelect2Attribute()
    {
        return $this->name;
    }

    public function hostname()
    {
        return $this->belongsTo(Hostname::class);
    }

    public function website()
    {
        return $this->belongsTo(Website::class);
    }

    public function distributor()
    {
        return $this->belongsTo(User::class,'distributor_id');
    }
}
