<?php

namespace App\Models\System;

use App\Models\Auth\User;
use App\Models\Shop\ShopProduct;
use Illuminate\Database\Eloquent\Model;
use Hyn\Tenancy\Traits\UsesSystemConnection;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\System\SysListPriceDistributor
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int|null $distributor_id
 * @property int|null $shop_product_id
 * @property float $price
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Auth\User|null $distributor
 * @property-read \App\Models\Shop\ShopProduct|null $shopProduct
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor userDistributor()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor whereDistributorId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor wherePrice($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor whereShopProductId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysListPriceDistributor whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class SysListPriceDistributor extends Model
{
    use Sortable,UsesSystemConnection;

    protected $table = 'sys_list_price_distributors';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'distributor_id',
        'shop_product_id',
        'price',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['created_at','price', 'sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('price', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhereHas('distributor', function ($q) use ($search) {
                $q->where('users.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            });
            $query->orWhereHas('shopProduct', function ($q) use ($search) {
                $q->where('shop_products.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            });
        }

        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function scopeUserDistributor($query)
    {
        $query->where('distributor_id','=',\Auth::user()->id);
        return $query;
    }

    public function distributor()
    {
        return $this->belongsTo(User::class,'distributor_id');
    }

    public function shopProduct()
    {
        return $this->belongsTo(ShopProduct::class,'shop_product_id');
    }

}
