<?php

namespace App\Models\System;

use App\Helpers\Helper;
use App\Models\Auth\User;
use App\Models\Catalogs\Currency;
use App\Models\Catalogs\PaymentWay;
use Hyn\Tenancy\Traits\UsesSystemConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\System\SysSalesOrder
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property int|null $sys_customer_id
 * @property string|null $email_created
 * @property int|null $currency_id
 * @property float $currency_value
 * @property string|null $product
 * @property string|null $product_code
 * @property float $quantity
 * @property float $price_unit
 * @property float $discount
 * @property float $price_reduce
 * @property float $amount_discount
 * @property float $amount_untaxed
 * @property float $amount_tax
 * @property float $amount_tax_ret
 * @property float $amount_total
 * @property int|null $payment_way_id
 * @property int|null $folio_id
 * @property string|null $activation_date
 * @property int $quantity_folio
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Auth\User|null $createdUser
 * @property-read \App\Models\Catalogs\Currency|null $currency
 * @property-read \App\Models\Catalogs\PaymentWay|null $paymentWay
 * @property-read \App\Models\System\SysCustomer|null $sysCustomer
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder totalDashboard($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder userDistributor()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereActivationDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereAmountDiscount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereAmountTax($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereAmountTaxRet($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereAmountTotal($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereAmountUntaxed($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereCurrencyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereCurrencyValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereDiscount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereEmailCreated($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereFolioId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder wherePaymentWayId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder wherePriceReduce($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder wherePriceUnit($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereProduct($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereProductCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereQuantity($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereQuantityFolio($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereSysCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder whereUpdatedUid($value)
 * @mixin \Eloquent
 * @property string|null $payment_platform
 * @property string|null $payment_platform_request
 * @property string|null $payment_platform_response
 * @property-read mixed $payment_platform_name
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder wherePaymentPlatform($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder wherePaymentPlatformRequest($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\System\SysSalesOrder wherePaymentPlatformResponse($value)
 */
class SysSalesOrder extends Model
{
    use Sortable,UsesSystemConnection;

    protected $table = 'sys_sales_orders';

    const PER_ACTIVE = 1; //Por activar
    const ACTIVE = 2; //Activos
    const CANCELED = 3; //Cancelado

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'sys_customer_id',
        'email_created',
        'currency_id',
        'currency_value',
        'product',
        'product_code',
        'quantity',
        'price_unit',
        'discount',
        'price_reduce',
        'amount_discount',
        'amount_untaxed',
        'amount_tax',
        'amount_tax_ret',
        'amount_total',
        'payment_way_id',
        'folio_id',
        'activation_date',
        'quantity_folio',
        'sort_order',
        'status',
        'payment_platform',
        'payment_platform_request',
        'payment_platform_response',
        'sys_customer_folio'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['created_at','name','sys_customer_id','product','product_code','quantity_folio', 'amount_total', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('product', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('product_code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('payment_platform', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhereHas('sysCustomer', function ($q) use ($search) {
                $q->where('sys_customers.taxid', '=', $search);
                $q->orWhere('sys_customers.name', '=', $search);
                $q->orWhere('sys_customers.email', '=', $search);
            });
        }

        if (!empty($input['filter_name'])) {
            $name = $input['filter_name'];
            $query->where('name', 'like', '%' . str_replace(' ', '%%', $name) . '%');
        }

        if (!empty($input['filter_sys_customer_id'])) {
            $sys_customer_id = $input['filter_sys_customer_id'];
            $query->where('sys_customer_id', '=', $sys_customer_id);
        }

        if (!empty($input['filter_date_from'])) {
            $query->whereDate('created_at', '>=', Helper::convertDateToSql($input['filter_date_from']));
        }
        if (!empty($input['filter_date_to'])) {
            $query->whereDate('created_at', '<=', Helper::convertDateToSql($input['filter_date_to']));
        }

        if (!empty($input['filter_payment_way_id'])) {
            $payment_way_id = $input['filter_payment_way_id'];
            $query->where('payment_way_id', '=', $payment_way_id);
        }

        if (!empty($input['filter_status'])) {
            $status = $input['filter_status'];
            $query->where('status', '=', $status);
        }

        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=',self::ACTIVE);

        return $query;
    }

    public function scopeUserDistributor($query)
    {
        $query->whereHas('sysCustomer', function ($q) {
            $q->where('sys_customers.distributor_id', '=', \Auth::user()->id);
        });

        return $query;
    }

    public function scopeTotalDashboard($query, array $input = []){
        $query->whereIn('status', [self::ACTIVE]);
        if (!empty($input['filter_date_from'])) {
            $query->whereDate('created_at', '>=', Helper::convertDateToSql($input['filter_date_from']));
        }
        if (!empty($input['filter_date_to'])) {
            $query->whereDate('created_at', '<=', Helper::convertDateToSql($input['filter_date_to']));
        }
        return $query;
    }

    public function getPaymentPlatformNameAttribute(){
        $payment_platform = collect(config('app.payment_platforms'))->where('code','=',$this->payment_platform)->first();
        return $payment_platform['name'] ?? $this->payment_platform;
    }

    public function sysCustomer()
    {
        return $this->belongsTo(SysCustomer::class);
    }

    public function paymentWay()
    {
        return $this->belongsTo(PaymentWay::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function createdUser()
    {
        return $this->belongsTo(User::class,'created_uid');
    }
}
