<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use View;

class ViewComposerServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        // All
        View::composer(
            '*', 'App\Http\ViewComposers\All'
        );

        // Logo
        View::composer(
            ['sales.*'], 'App\Http\ViewComposers\Logo'
        );

        // Add limits to index
        View::composer(
            ['*.index','base.settings.edit'], 'App\Http\ViewComposers\Index'
        );

    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
