<?php

namespace App\Services;


use App\Traits\ConsumesExternalServices;
use Illuminate\Http\Request;

class StripeService
{
    use ConsumesExternalServices;

    protected $baseUri;

    protected $key;

    protected $secret;

    public function __construct()
    {
        $this->baseUri = config('services.stripe.base_uri');
        $this->key = config('services.stripe.key');
        $this->secret = config('services.stripe.secret');
    }

    /**
     * Resuelve autorizacion
     *
     * @param $queryParams
     * @param $formParams
     * @param $headers
     */
    public function resolveAuthorization(&$queryParams, &$formParams, &$headers)
    {
        $headers['Authorization'] = $this->resolveAccessToken();
    }

    /**
     * Decodifica la respuesta
     *
     * @param $response
     * @return mixed
     */
    public function decodeResponse($response)
    {
        return json_decode($response);
    }

    /**
     * Resuelve token
     *
     * @return string
     */
    public function resolveAccessToken()
    {
        return 'Bearer ' . $this->secret;
    }

    /**
     * Realiza la intencion de pago
     *
     * @param $value
     * @param $currency
     * @param $payment_platform_request
     * @return mixed
     * @throws \Exception
     */
    public function handlePayment($value, $currency, $payment_platform_request)
    {
    }

    /**
     * Realiza la aprovacion del pago
     *
     * @param $payment_platform_request
     * @param $payment_platform_response
     * @return mixed
     */
    public function handleApproval($payment_platform_request, $payment_method)
    {
    }

    public function createIntent($sys_sales_order_name, $value, $currency, $payment_platform_request)
    {
        //
        $cart = \Cart::session(\Auth::user()->id)->getContent()->first();

        //Realiza la creacion de una orden de pago
        $data = [
            'amount' => round($value * $this->resolveFactor($currency)),
            'currency' => strtolower($currency),
            'payment_method_types' => ['card'],
            'payment_method' => $payment_platform_request['payment_method'],
            'confirmation_method' => 'manual',
            'description' => $sys_sales_order_name . ' / ' . str_limit($cart->name, 50),
        ];
        $paymentIntent = $this->makeRequest(
            'POST',
            '/v1/payment_intents',
            [],
            $data
        );
        $payment_platform_request['paymentIntentId'] = $paymentIntent->id;
        $payment_platform_request['capture_method'] = $paymentIntent->capture_method;
        $payment_platform_request['status'] = $paymentIntent->status;

        return $payment_platform_request;
    }

    public function confirmPayment($paymentIntentId){
        return $this->makeRequest(
            'POST',
            '/v1/payment_intents/' . $paymentIntentId . '/confirm',
        );
    }

    public function resolveFactor($currency)
    {
        return 100;
    }
}
