<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Application Name
    |--------------------------------------------------------------------------
    |
    | This value is the name of your application. This value is used when the
    | framework needs to place the application's name in a notification or
    | any other location as required by the application or its packages.
    |
    */

    'name' => env('APP_NAME', 'Laravel'),
    'version' => env('APP_VERSION', '0.0.0'),
    'cfdi_footer' => env('APP_CFDI_FOOTER', ''),
    'company' => env('APP_COMPANY', 'Yamiss Soft'),
    'company_url' => env('APP_COMPANY_URL', 'http://www.yamiss.com'),
    'tenant_base_url' => env('TENANT_BASE_URL', ''),
    'godaddy_api_key' => env('GODADDY_API_KEY', ''),
    'godaddy_api_secret' => env('GODADDY_API_SECRET', ''),
    'godaddy_records_a_data' => env('GODADDY_RECORDS_A_DATA', ''),
    'pac_name' => env('PAC_NAME', ''),
    'pac_code' => env('PAC_CODE', ''),
    'pac_key' => env('PAC_KEY', ''),
    'pac_secret' => env('PAC_SECRET', ''),
    'pac_team_id' => env('PAC_TEAM_ID', ''),
    'pac_token' => env('PAC_TOKEN', ''),

    //
    'account_days_request_customer_invoice' => env('ACCOUNT_DAYS_REQUEST_CUSTOMER_INVOICE', ''),
    'account_folios_free' => env('ACCOUNT_FOLIOS_FREE', ''),
    'shared_hosting' => env('SHARED_HOSTING', false),

    //Videos de la aplicacion
    'url_videotutorial' => env('URL_VIDEOTUTORIAL', ''),

    //correos de alertas
    'mail_cart_alert' => env('MAIL_CART_ALERT', ''),
    'mail_tenant_alert' => env('MAIL_TENANT_ALERT', ''),

    //Chat smartsupp
    'smartsupp_key' => env('SMARTSUPP_KEY', ''),
    'tawk_key' => env('TAWK_KEY', ''),

    //
    'optinly_key' => env('OPTINLY_KEY', ''),

    //
    'usetiful_key' => env('USETIFUL_KEY', ''),

    //
    'custom_template_default' => env('CUSTOM_TEMPLATE_DEFAULT', false),
    'enabled_register_tenant' => env('ENABLED_REGISTER_TENANT', false),

    //Plataformas de pago
    'payment_platforms' => [
        [
            'code' => 'oxxo',
            'name' => 'Depósito en OXXO',
            'image' => 'img/payment_platforms/oxxo.png',
            'active' => env('OXXO_BANK', '') ? true : false
        ],
        [
            'code' => 'deposit_transfer',
            'name' => 'Depósito/Transferencia',
            'image' => 'img/payment_platforms/deposit_transfer.jpg',
            'active' => env('DEPOSIT_TRANSFER_BANK', '') ? true : false
        ],
        [
            'code' => 'sinvacrem',
            'name' => 'Depósito en Sinvacrem',
            'image' => 'img/payment_platforms/sinvacrem.png',
            'active' => env('SINVACREM_NAME', '') ? true : false
        ],
        [
            'code' => 'bancoppel',
            'name' => 'Depósito en Bancoppel',
            'image' => 'img/payment_platforms/bancoppel.jpg',
            'active' => env('BANCOPPEL_NAME', '') ? true : false
        ],
        [
            'code' => 'paypal',
            'name' => 'Pago con PayPal',
            'image' => 'img/payment_platforms/paypal.jpg',
            'active' => env('PAYPAL_CLIENT_ID', '') ? true : false
        ],
        [
            'code' => 'stripe',
            'name' => 'Tarjeta de Débito/Crédito',
            'image' => 'img/payment_platforms/stripe.png',
            'active' => env('STRIPE_KEY', '') ? true : false
        ]
    ],

    //Avisos para pago
    'payment_notice_1' => env('PAYMENT_NOTICE_1', ''),
    'payment_notice_2' => env('PAYMENT_NOTICE_2', ''),
    'payment_notice_3' => env('PAYMENT_NOTICE_3', ''),

    'frequencies' => [
        'D1' => 'Diario',
        'W1' => 'Semanal',
        'M1' => 'Mensual',
        'M2' => 'Bimestral',
        'M6' => 'Semestral',
        'Y1' => 'Anual',
    ],

    /*
    |--------------------------------------------------------------------------
    | Application Environment
    |--------------------------------------------------------------------------
    |
    | This value determines the "environment" your application is currently
    | running in. This may determine how you prefer to configure various
    | services your application utilizes. Set this in your ".env" file.
    |
    */

    'env' => env('APP_ENV', 'production'),

    /*
    |--------------------------------------------------------------------------
    | Application Debug Mode
    |--------------------------------------------------------------------------
    |
    | When your application is in debug mode, detailed error messages with
    | stack traces will be shown on every error that occurs within your
    | application. If disabled, a simple generic error page is shown.
    |
    */

    'debug' => env('APP_DEBUG', false),

    /*
    |--------------------------------------------------------------------------
    | Application URL
    |--------------------------------------------------------------------------
    |
    | This URL is used by the console to properly generate URLs when using
    | the Artisan command line tool. You should set this to the root of
    | your application so that it is used when running Artisan tasks.
    |
    */

    'url' => env('APP_URL', 'http://localhost'),

    /*
    |--------------------------------------------------------------------------
    | Application Timezone
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default timezone for your application, which
    | will be used by the PHP date and date-time functions. We have gone
    | ahead and set this to a sensible default for you out of the box.
    |
    */

    'timezone' => env('APP_TIMEZONE', 'America/Mexico_City'),

    /*
    |--------------------------------------------------------------------------
    | Application Locale Configuration
    |--------------------------------------------------------------------------
    |
    | The application locale determines the default locale that will be used
    | by the translation service provider. You are free to set this value
    | to any of the locales which will be supported by the application.
    |
    */

    'locale' => 'es_MX',

    /*
    |--------------------------------------------------------------------------
    | Application Fallback Locale
    |--------------------------------------------------------------------------
    |
    | The fallback locale determines the locale to use when the current one
    | is not available. You may change the value to correspond to any of
    | the language folders that are provided through your application.
    |
    */

    'fallback_locale' => 'en',

    /*
    |--------------------------------------------------------------------------
    | Encryption Key
    |--------------------------------------------------------------------------
    |
    | This key is used by the Illuminate encrypter service and should be set
    | to a random, 32 character string, otherwise these encrypted strings
    | will not be safe. Please do this before deploying an application!
    |
    */

    'key' => env('APP_KEY'),

    'cipher' => 'AES-256-CBC',

    /*
    |--------------------------------------------------------------------------
    | Autoloaded Service Providers
    |--------------------------------------------------------------------------
    |
    | The service providers listed here will be automatically loaded on the
    | request to your application. Feel free to add your own services to
    | this array to grant expanded functionality to your applications.
    |
    */

    'providers' => [

        /*
         * Laravel Framework Service Providers...
         */
        Illuminate\Auth\AuthServiceProvider::class,
        Illuminate\Broadcasting\BroadcastServiceProvider::class,
        Illuminate\Bus\BusServiceProvider::class,
        Illuminate\Cache\CacheServiceProvider::class,
        Illuminate\Foundation\Providers\ConsoleSupportServiceProvider::class,
        Illuminate\Cookie\CookieServiceProvider::class,
        Illuminate\Database\DatabaseServiceProvider::class,
        Illuminate\Encryption\EncryptionServiceProvider::class,
        Illuminate\Filesystem\FilesystemServiceProvider::class,
        Illuminate\Foundation\Providers\FoundationServiceProvider::class,
        Illuminate\Hashing\HashServiceProvider::class,
        Illuminate\Mail\MailServiceProvider::class,
        Illuminate\Notifications\NotificationServiceProvider::class,
        Illuminate\Pagination\PaginationServiceProvider::class,
        Illuminate\Pipeline\PipelineServiceProvider::class,
        Illuminate\Queue\QueueServiceProvider::class,
        Illuminate\Redis\RedisServiceProvider::class,
        Illuminate\Auth\Passwords\PasswordResetServiceProvider::class,
        Illuminate\Session\SessionServiceProvider::class,
        Illuminate\Translation\TranslationServiceProvider::class,
        Illuminate\Validation\ValidationServiceProvider::class,
        Illuminate\View\ViewServiceProvider::class,

        /*
         * Package Service Providers...
         */
        Darryldecode\Cart\CartServiceProvider::class,

        /*
         * Application Service Providers...
         */
        App\Providers\AppServiceProvider::class,
        App\Providers\AuthServiceProvider::class,
        // App\Providers\BroadcastServiceProvider::class,
        App\Providers\EventServiceProvider::class,
        App\Providers\RouteServiceProvider::class,
        App\Providers\ViewComposerServiceProvider::class,
        Rap2hpoutre\LaravelLogViewer\LaravelLogViewerServiceProvider::class,
        App\Providers\DropboxServiceProvider::class

    ],

    /*
    |--------------------------------------------------------------------------
    | Class Aliases
    |--------------------------------------------------------------------------
    |
    | This array of class aliases will be registered when this application
    | is started. However, feel free to register as many as you wish as
    | the aliases are "lazy" loaded so they don't hinder performance.
    |
    */

    'aliases' => [

        'App' => Illuminate\Support\Facades\App::class,
        'Artisan' => Illuminate\Support\Facades\Artisan::class,
        'Auth' => Illuminate\Support\Facades\Auth::class,
        'Blade' => Illuminate\Support\Facades\Blade::class,
        'Broadcast' => Illuminate\Support\Facades\Broadcast::class,
        'Bus' => Illuminate\Support\Facades\Bus::class,
        'Cache' => Illuminate\Support\Facades\Cache::class,
        'Config' => Illuminate\Support\Facades\Config::class,
        'Cookie' => Illuminate\Support\Facades\Cookie::class,
        'Crypt' => Illuminate\Support\Facades\Crypt::class,
        'DB' => Illuminate\Support\Facades\DB::class,
        'Eloquent' => Illuminate\Database\Eloquent\Model::class,
        'Event' => Illuminate\Support\Facades\Event::class,
        'File' => Illuminate\Support\Facades\File::class,
        'Gate' => Illuminate\Support\Facades\Gate::class,
        'Hash' => Illuminate\Support\Facades\Hash::class,
        'Lang' => Illuminate\Support\Facades\Lang::class,
        'Log' => Illuminate\Support\Facades\Log::class,
        'Mail' => Illuminate\Support\Facades\Mail::class,
        'Notification' => Illuminate\Support\Facades\Notification::class,
        'Password' => Illuminate\Support\Facades\Password::class,
        'Queue' => Illuminate\Support\Facades\Queue::class,
        'Redirect' => Illuminate\Support\Facades\Redirect::class,
        'Redis' => Illuminate\Support\Facades\Redis::class,
        'Request' => Illuminate\Support\Facades\Request::class,
        'Response' => Illuminate\Support\Facades\Response::class,
        'Route' => Illuminate\Support\Facades\Route::class,
        'Schema' => Illuminate\Support\Facades\Schema::class,
        'Session' => Illuminate\Support\Facades\Session::class,
        'Storage' => Illuminate\Support\Facades\Storage::class,
        'URL' => Illuminate\Support\Facades\URL::class,
        'Validator' => Illuminate\Support\Facades\Validator::class,
        'View' => Illuminate\Support\Facades\View::class,
    ],

    'debug_blacklist' => [
        '_COOKIE' => array_keys($_COOKIE),
        '_SERVER' => array_keys($_SERVER),
        '_ENV' => array_keys($_ENV),
    ],

];
