<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Stripe, Mailgun, SparkPost and others. This file provides a sane
    | default location for this type of information, allowing packages
    | to have a conventional place to find your various credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
    ],

    'ses' => [
        'key' => env('SES_KEY'),
        'secret' => env('SES_SECRET'),
        'region' => env('SES_REGION', 'us-east-1'),
    ],

    'sparkpost' => [
        'secret' => env('SPARKPOST_SECRET'),
    ],
    'oxxo' => [
        'bank' => env('OXXO_BANK'),
        'debit_card' => env('OXXO_DEBIT_CARD'),
        'text_confirm_payment' => env('OXXO_TEXT_CONFIRM_PAYMENT'),
        'class' => '',
    ],
    'deposit_transfer' => [
        'bank' => env('DEPOSIT_TRANSFER_BANK'),
        'name' => env('DEPOSIT_TRANSFER_NAME'),
        'number' => env('DEPOSIT_TRANSFER_NUMBER'),
        'clabe_number' => env('DEPOSIT_TRANSFER_CLABE_NUMBER'),
        'debit_card' => env('DEPOSIT_TRANSFER_DEBIT_CARD'),
        'text_confirm_payment' => env('DEPOSIT_TRANSFER_TEXT_CONFIRM_PAYMENT'),
        'class' => '',
    ],
    'sinvacrem' => [
        'name' => env('SINVACREM_NAME'),
        'partner' => env('SINVACREM_PARTNER'),
        'number' => env('SINVACREM_NUMBER'),
        'text_confirm_payment' => env('SINVACREM_TEXT_CONFIRM_PAYMENT'),
        'class' => '',
    ],
    'bancoppel' => [
        'name' => env('BANCOPPEL_NAME'),
        'number' => env('BANCOPPEL_NUMBER'),
        'debit_card' => env('BANCOPPEL_DEBIT_CARD'),
        'text_confirm_payment' => env('BANCOPPEL_TEXT_CONFIRM_PAYMENT'),
        'class' => '',
    ],
    'paypal' => [
        'base_uri' => \App\Helpers\Helper::testEnvironment() ? env('PAYPAL_BASE_URI_TEST') : env('PAYPAL_BASE_URI'),
        'client_id' => env('PAYPAL_CLIENT_ID'),
        'client_secret' => env('PAYPAL_CLIENT_SECRET'),
        'text_confirm_payment' => env('PAYPAL_TEXT_CONFIRM_PAYMENT'),
        'class' => App\Services\PaypalService::class,
    ],
    'stripe' => [
        'base_uri' => env('STRIPE_BASE_URI'),
        'key' => env('STRIPE_KEY'),
        'secret' => env('STRIPE_SECRET'),
        'text_confirm_payment' => env('STRIPE_TEXT_CONFIRM_PAYMENT'),
        'class' => App\Services\StripeService::class,
    ],

];
