<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSysCustomersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sys_customers', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->string('name',250);
            $table->string('taxid',15)->nullable();
            $table->string('email',100)->nullable();
            $table->string('password')->nullable();
            $table->string('phone',100)->nullable();
            $table->string('record')->nullable();
            $table->string('domain')->nullable();
            $table->string('fqdn')->nullable();
            $table->unsignedBigInteger('hostname_id')->nullable();
            $table->unsignedBigInteger('website_id')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('hostname_id')->references('id')->on('hostnames')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('website_id')->references('id')->on('websites')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sys_customers');
    }
}
