<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateShopProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shop_products', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->string('name');
            $table->string('code',64)->nullable();
            $table->string('slug')->nullable();
            $table->text('description')->nullable();
            $table->string('image')->nullable();
            $table->decimal('price',15,5)->default(0);
            $table->integer('quantity_folio')->default(0);
            $table->boolean('top')->default(FALSE);
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');
            $table->unique('code','code','BTREE');
            $table->unique('slug','slug','BTREE');

            // Foreign
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shop_products');
    }
}
