<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateShopProductTaxesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shop_product_taxes', function (Blueprint $table) {
            // Campos
            $table->unsignedInteger('shop_product_id')->nullable();
            $table->unsignedInteger('tax_id')->nullable();

            // Index
            $table->index('shop_product_id','shop_product_id','BTREE');
            $table->index('tax_id','tax_id','BTREE');

            // Llave primaria
            $table->primary(['shop_product_id','tax_id']);

            // Foreign
            $table->foreign('shop_product_id')->references('id')->on('shop_products')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('tax_id')->references('id')->on('shop_taxes')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shop_product_taxes');
    }
}
