<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSysSalesOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sys_sales_orders', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->string('name',250);
            $table->unsignedInteger('sys_customer_id')->nullable();
            $table->string('email_created',100)->nullable();
            $table->unsignedInteger('currency_id')->nullable();
            $table->decimal('currency_value',15,8)->default(0);
            $table->string('product')->nullable();
            $table->string('product_code',100)->nullable();
            $table->decimal('quantity',15,5)->default(0);
            $table->decimal('price_unit',15,5)->default(0);
            $table->decimal('discount',15,3)->default(0);
            $table->decimal('price_reduce',15,5)->default(0);
            $table->decimal('amount_discount',15,5)->default(0);
            $table->decimal('amount_untaxed',15,5)->default(0);
            $table->decimal('amount_tax',15,5)->default(0);
            $table->decimal('amount_tax_ret',15,5)->default(0);
            $table->decimal('amount_total',15,5)->default(0);
            $table->unsignedInteger('payment_way_id')->nullable();
            $table->unsignedInteger('folio_id')->nullable();
            $table->dateTime('activation_date')->nullable();
            $table->integer('quantity_folio')->default(1);
            $table->integer('sort_order')->default(0);
            $table->tinyInteger('status')->default(\App\Models\System\SysSalesOrder::PER_ACTIVE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('sys_customer_id')->references('id')->on('sys_customers')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sys_sales_orders');
    }
}
