<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPermissionToUsers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->boolean('p_customers')->default(TRUE);
            $table->boolean('p_products')->default(TRUE);
            $table->boolean('p_customer_quotations')->default(TRUE);
            $table->boolean('p_cfdis')->default(TRUE);
            $table->boolean('p_payrolls')->default(TRUE);
            $table->boolean('p_tax_mailbox')->default(TRUE);
            $table->boolean('p_cfdi_downloads')->default(TRUE);
            $table->boolean('p_bank_reconciliations')->default(TRUE);
            $table->boolean('p_catalogs')->default(TRUE);
            $table->boolean('p_branch_offices')->default(TRUE);
            $table->boolean('p_companies')->default(TRUE);
            $table->boolean('p_add_companies')->default(TRUE);
            $table->boolean('p_edit_companies')->default(TRUE);
            $table->boolean('p_settings')->default(TRUE);
            $table->boolean('p_admin')->default(TRUE);
            $table->boolean('p_users')->default(TRUE);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('p_customers');
            $table->dropColumn('p_products');
            $table->dropColumn('p_customer_quotations');
            $table->dropColumn('p_cfdis');
            $table->dropColumn('p_payrolls');
            $table->dropColumn('p_tax_mailbox');
            $table->dropColumn('p_cfdi_downloads');
            $table->dropColumn('p_bank_reconciliations');
            $table->dropColumn('p_catalogs');
            $table->dropColumn('p_branch_offices');
            $table->dropColumn('p_companies');
            $table->dropColumn('p_add_companies');
            $table->dropColumn('p_edit_companies');
            $table->dropColumn('p_settings');
            $table->dropColumn('p_admin');
            $table->dropColumn('p_users');
        });
    }
}
