<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCurrenciesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('currencies', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            //Campos
            $table->string('name');
            $table->string('code',3);
            $table->decimal('rate',15,8)->default(0);
            $table->unsignedInteger('decimal_place')->default(2);
            $table->string('symbol',3)->nullable();
            $table->string('symbol_position',1)->default('L');
            $table->string('decimal_mark',1)->default('.');
            $table->string('thousands_separator',1)->default(',');
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            //Index
            $table->index('id','id','BTREE');
            $table->unique('code','code','BTREE');

            //Foreign
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('currencies');
    }
}
