<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCountriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('countries', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            //Campos
            $table->string('name');
            $table->string('code',3);
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            //Index
            $table->index('id','id','BTREE');
            $table->unique('code','code','BTREE');

            //Foreign
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('countries');
    }
}
