<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('states', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            //Campos
            $table->string('name');
            $table->unsignedInteger('country_id')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            //Index
            $table->index('id','id','BTREE');

            //Foreign
            $table->foreign('country_id')->references('id')->on('countries')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('states');
    }
}
