<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDocumentTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('document_types', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->string('name');
            $table->string('code',50);
            $table->string('prefix',34)->nullable();
            $table->integer('current_number')->default(0);
            $table->integer('increment_number')->default(1);
            $table->tinyInteger('nature')->default(\App\Models\Base\DocumentType::NO_NATURE);
            $table->unsignedInteger('cfdi_type_id')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');
            $table->unique('code','code','BTREE');

            // Foreign
            $table->foreign('cfdi_type_id')->references('id')->on('cfdi_types')->onUpdate('cascade')->onDelete('restrict');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('document_types');
    }
}
