<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->string('name',250);
            $table->string('taxid',15)->nullable();
            $table->string('numid',20)->nullable(); //Indentidad fiscal
            $table->string('email',100)->nullable();
            $table->string('phone',100)->nullable();
            $table->string('phone_mobile',100)->nullable();
            $table->unsignedInteger('payment_term_id')->nullable();
            $table->unsignedInteger('payment_way_id')->nullable();
            $table->unsignedInteger('payment_method_id')->nullable();
            $table->unsignedInteger('cfdi_use_id')->nullable();
            $table->unsignedInteger('salesperson_id')->nullable();
            $table->string('address_1',100)->nullable(); //Direccion
            $table->string('address_2',50)->nullable(); //Num. Ext
            $table->string('address_3',50)->nullable(); //Num Int.
            $table->string('address_4',100)->nullable(); //Colonia
            $table->string('address_5',100)->nullable(); //Localidad
            $table->string('address_6',150)->nullable(); //Referencia
            $table->unsignedInteger('city_id')->nullable(); //Municipio
            $table->unsignedInteger('state_id')->nullable(); //Estado
            $table->unsignedInteger('country_id'); //Pais
            $table->string('postcode',10)->nullable(); //CP
            $table->text('comment')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('payment_term_id')->references('id')->on('payment_terms')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('payment_way_id')->references('id')->on('payment_ways')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('payment_method_id')->references('id')->on('payment_methods')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('cfdi_use_id')->references('id')->on('cfdi_uses')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('salesperson_id')->references('id')->on('salespersons')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('city_id')->references('id')->on('cities')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('state_id')->references('id')->on('states')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('country_id')->references('id')->on('countries')->onUpdate('cascade')->onDelete('restrict');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customers');
    }
}
