<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerBankAccountsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_bank_accounts', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->unsignedInteger('customer_id');
            $table->string('name', 100);
            $table->string('account_number', 100);
            $table->unsignedInteger('bank_id');
            $table->unsignedInteger('currency_id');
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(true);

            // Index
            $table->index('id', 'id', 'BTREE');

            // Foreign
            $table->foreign('customer_id')->references('id')->on('customers')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('bank_id')->references('id')->on('banks')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('currency_id')->references('id')->on('currencies')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_bank_accounts');
    }
}
