<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->string('name');
            $table->string('code',64)->nullable();
            $table->text('description')->nullable();
            $table->string('image')->nullable();
            $table->string('model',64)->nullable(); //Modelo
            $table->string('manufacturer',64)->nullable(); //Marca
            $table->decimal('price',15,5)->default(0);
            $table->unsignedInteger('unit_measure_id')->nullable();
            $table->unsignedInteger('sat_product_id')->nullable();
            $table->text('comment')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');
            $table->unique('code','code','BTREE');

            // Foreign
            $table->foreign('unit_measure_id')->references('id')->on('unit_measures')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('sat_product_id')->references('id')->on('sat_products')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
