<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductTaxesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_taxes', function (Blueprint $table) {
            // Campos
            $table->unsignedInteger('product_id');
            $table->unsignedInteger('tax_id');

            // Index
            $table->index('product_id','product_id','BTREE');
            $table->index('tax_id','tax_id','BTREE');

            // Llave primaria
            $table->primary(['product_id','tax_id']);

            // Foreign
            $table->foreign('product_id')->references('id')->on('products')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('tax_id')->references('id')->on('taxes')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_taxes');
    }
}
