<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_invoices', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->string('name',50);
            $table->string('serie',34)->nullable();
            $table->integer('folio')->nullable();
            $table->dateTime('date')->nullable();
            $table->date('date_due')->nullable();
            $table->string('reference',100)->nullable();
            $table->unsignedInteger('customer_id')->nullable();
            $table->unsignedInteger('branch_office_id')->nullable();
            $table->unsignedInteger('payment_term_id')->nullable();
            $table->unsignedInteger('payment_way_id')->nullable();
            $table->unsignedInteger('payment_method_id')->nullable();
            $table->unsignedInteger('cfdi_use_id')->nullable();
            $table->unsignedInteger('salesperson_id')->nullable();
            $table->unsignedInteger('currency_id')->nullable();
            $table->decimal('currency_value',15,8)->default(0);
            $table->decimal('amount_discount',15,5)->default(0);
            $table->decimal('amount_untaxed',15,5)->default(0);
            $table->decimal('amount_tax',15,5)->default(0);
            $table->decimal('amount_tax_ret',15,5)->default(0);
            $table->decimal('amount_total',15,5)->default(0);
            $table->decimal('balance',15,5)->default(0);
            $table->unsignedInteger('document_type_id')->nullable();
            $table->unsignedInteger('cfdi_relation_id')->nullable();
            $table->text('comment')->nullable();
            $table->boolean('mail_sent')->default(FALSE);
            $table->integer('sort_order')->default(0);
            $table->tinyInteger('status')->default(\App\Models\Sales\CustomerInvoice::OPEN);

            // Index
            $table->index('id','id','BTREE');
            $table->unique('name','name','BTREE');

            // Foreign
            $table->foreign('customer_id')->references('id')->on('customers')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('branch_office_id')->references('id')->on('branch_offices')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('payment_term_id')->references('id')->on('payment_terms')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('payment_way_id')->references('id')->on('payment_ways')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('payment_method_id')->references('id')->on('payment_methods')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('cfdi_use_id')->references('id')->on('cfdi_uses')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('salesperson_id')->references('id')->on('salespersons')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('currency_id')->references('id')->on('currencies')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('document_type_id')->references('id')->on('document_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('cfdi_relation_id')->references('id')->on('cfdi_relations')->onUpdate('cascade')->onDelete('restrict');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_invoices');
    }
}
