<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_payments', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->string('name',50);
            $table->string('serie',34)->nullable();
            $table->integer('folio')->nullable();
            $table->dateTime('date')->nullable();
            $table->dateTime('date_payment')->nullable();
            $table->string('reference',100)->nullable();
            $table->unsignedInteger('company_bank_account_id')->nullable();
            $table->unsignedInteger('customer_id')->nullable();
            $table->unsignedInteger('customer_bank_account_id')->nullable();
            $table->unsignedInteger('branch_office_id')->nullable();
            $table->unsignedInteger('payment_way_id')->nullable();
            $table->unsignedInteger('currency_id')->nullable();
            $table->decimal('currency_value',15,8)->default(0);
            $table->decimal('amount',15,5)->default(0);
            $table->decimal('balance',15,5)->default(0);
            $table->unsignedInteger('document_type_id')->nullable();
            $table->unsignedInteger('cfdi_relation_id')->nullable();
            $table->boolean('cfdi')->default(FALSE);
            $table->text('comment')->nullable();
            $table->boolean('mail_sent')->default(FALSE);
            $table->integer('sort_order')->default(0);
            $table->tinyInteger('status')->default(\App\Models\Sales\CustomerPayment::OPEN);

            // Index
            $table->index('id','id','BTREE');
            $table->unique('name','name','BTREE');


            // Foreign
            $table->foreign('company_bank_account_id')->references('id')->on('company_bank_accounts')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('customer_id')->references('id')->on('customers')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('customer_bank_account_id')->references('id')->on('customer_bank_accounts')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('branch_office_id')->references('id')->on('branch_offices')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('payment_way_id')->references('id')->on('payment_ways')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('currency_id')->references('id')->on('currencies')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('cfdi_relation_id')->references('id')->on('cfdi_relations')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_payments');
    }
}
