<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerPaymentReconciledsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_payment_reconcileds', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->unsignedInteger('customer_payment_id');
            $table->text('name');
            $table->unsignedInteger('reconciled_id')->nullable();
            $table->decimal('currency_value',15,8)->default(0)->nullable();
            $table->decimal('amount_reconciled',15,5)->default(0);
            $table->decimal('last_balance',15,5)->default(0);
            $table->integer('number_of_payment')->default(1);
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('customer_payment_id')->references('id')->on('customer_payments')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('reconciled_id')->references('id')->on('customer_invoices')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_payment_reconcileds');
    }
}
