<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerInvoiceLineComplementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_invoice_line_complements', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->unsignedInteger('customer_invoice_line_id')->nullable();
            $table->text('name')->nullable();
            $table->unsignedInteger('customer_iedu_id')->nullable();
            $table->string('iedu_nombre_alumno')->nullable();
            $table->string('iedu_curp')->nullable();
            $table->string('iedu_nivel_educativo')->nullable();
            $table->string('iedu_aut_rvoe')->nullable();
            $table->string('iedu_rfc_pago')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('customer_invoice_line_id','cin_line_complements_customer_invoice_line_id_fk')->references('id')->on('customer_invoice_lines')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('customer_iedu_id','cin_line_complements_customer_iedu_id_fk')->references('id')->on('customer_iedus')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_invoice_line_complements');
    }
}
