<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFoliosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('folios', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->string('name',250);
            $table->string('taxid',15)->nullable();
            $table->string('product')->nullable();
            $table->string('product_code',100)->nullable();
            $table->decimal('quantity',15,5)->default(0);
            $table->decimal('price_unit',15,5)->default(0);
            $table->decimal('discount',15,3)->default(0);
            $table->decimal('price_reduce',15,5)->default(0);
            $table->unsignedInteger('payment_way_id')->nullable();
            $table->unsignedInteger('currency_id')->nullable();
            $table->decimal('currency_value',15,8)->default(0);
            $table->decimal('amount_discount',15,5)->default(0);
            $table->decimal('amount_untaxed',15,5)->default(0);
            $table->decimal('amount_tax',15,5)->default(0);
            $table->decimal('amount_tax_ret',15,5)->default(0);
            $table->decimal('amount_total',15,5)->default(0);
            $table->date('expiry_date')->nullable();
            $table->dateTime('activation_date')->nullable();
            $table->string('activation_code')->nullable();
            $table->integer('quantity_folio')->default(1);
            $table->integer('available_folio')->default(0);
            $table->integer('sort_order')->default(0);
            $table->tinyInteger('status')->default(\App\Models\Base\Folio::PER_ACTIVE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('payment_way_id')->references('id')->on('payment_ways')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('currency_id')->references('id')->on('currencies')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('folios');
    }
}
