<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTransferToCustomerInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customer_invoices', function (Blueprint $table) {
            $table->date('date_delivery')->nullable();
            $table->string('source')->nullable();
            $table->text('source_name')->nullable();
            $table->text('source_taxid')->nullable();
            $table->text('source_address')->nullable();
            $table->text('source_delivery_on')->nullable();
            $table->string('destination')->nullable();
            $table->string('destination_name')->nullable();
            $table->string('destination_taxid')->nullable();
            $table->text('destination_address')->nullable();
            $table->text('destination_delivery_on')->nullable();
            $table->decimal('valid_amount',15,5)->default(0);
            $table->boolean('dangerous_material')->default(FALSE);
            $table->string('compensation')->nullable();
            $table->string('retainer_name')->nullable();
            $table->string('retainer_taxid')->nullable();
            $table->string('driver')->nullable();
            $table->string('vehicle')->nullable();
            $table->string('vehicle_number')->nullable();
            $table->string('vehicle_counter')->nullable();
            $table->string('cfdi_type2')->nullable(); //invoice, transfer, lease, fee, credit_note, payment
            $table->string('document_type2')->nullable(); //invoice, transfer
            //descripcion de mercancias
            //peso
            //metroscubicos
            //litros
            //Hoja de politicas
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customer_invoices', function (Blueprint $table) {
            $table->dropColumn('date_delivery');
            $table->dropColumn('source');
            $table->dropColumn('source_name');
            $table->dropColumn('source_taxid');
            $table->dropColumn('source_address');
            $table->dropColumn('source_delivery_on');
            $table->dropColumn('destination');
            $table->dropColumn('destination_name');
            $table->dropColumn('destination_taxid');
            $table->dropColumn('destination_address');
            $table->dropColumn('destination_delivery_on');
            $table->dropColumn('valid_amount');
            $table->dropColumn('dangerous_material');
            $table->dropColumn('compensation');
            $table->dropColumn('retainer_name');
            $table->dropColumn('retainer_taxid');
            $table->dropColumn('driver');
            $table->dropColumn('vehicle');
            $table->dropColumn('vehicle_number');
            $table->dropColumn('vehicle_counter');
            $table->dropColumn('cfdi_type2');
            $table->dropColumn('document_type2');
        });
    }
}
