<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSettingsToCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->string('color_primary',50)->nullable();
            $table->string('product_price_decimal_place',50)->nullable();
            $table->string('pdf_template',50)->nullable();
            $table->string('complemento_cfdi_iedu',50)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->dropColumn('color_primary');
            $table->dropColumn('product_price_decimal_place');
            $table->dropColumn('pdf_template');
            $table->dropColumn('complemento_cfdi_iedu');
        });
    }
}
