<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddUuidRelatedToCustomerInvoiceRelations extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customer_invoice_relations', function (Blueprint $table) {
            $table->unsignedInteger('relation_id')->nullable()->change();
            $table->string('uuid_related')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customer_invoice_relations', function (Blueprint $table) {
            $table->unsignedInteger('relation_id')->nullable(false)->change();
            $table->dropColumn('uuid_related');
        });
    }
}
