<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddUuidRelatedToCustomerPaymentReconcileds extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customer_payment_reconcileds', function (Blueprint $table) {
            $table->string('uuid_related')->nullable();
            $table->string('serie_related',34)->nullable();
            $table->integer('folio_related')->nullable();
            $table->string('currency_code_related')->nullable();
            $table->string('payment_method_code_related')->nullable();
            $table->decimal('current_balance',15,5)->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customer_payment_reconcileds', function (Blueprint $table) {
            $table->dropColumn('uuid_related');
            $table->dropColumn('serie_related');
            $table->dropColumn('folio_related');
            $table->dropColumn('currency_code_related');
            $table->dropColumn('payment_method_code_related');
            $table->dropColumn('current_balance');
        });
    }
}
