<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddForeignTradeToCustomerInvoices extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customer_invoices', function (Blueprint $table) {
            // Campos
            $table->unsignedInteger('transfer_reason_id')->nullable();
            $table->unsignedInteger('operation_type_id')->nullable();
            $table->unsignedInteger('pediment_id')->nullable();
            $table->string('origin_certificate')->nullable();
            $table->string('number_origin_certificate')->nullable();
            $table->string('reliable_exporter_number')->nullable();
            $table->unsignedInteger('incoterm_id')->nullable();
            $table->string('subdivision')->nullable();
            $table->text('comment_foreign_trade')->nullable();
            $table->decimal('exchange_rate_usd',15,8)->default(0);
            $table->decimal('amount_total_usd',15,5)->default(0);

            // Foreign
            $table->foreign('transfer_reason_id')->references('id')->on('transfer_reasons')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('operation_type_id')->references('id')->on('operation_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('pediment_id')->references('id')->on('pediments')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('incoterm_id')->references('id')->on('incoterms')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customer_invoices', function (Blueprint $table) {
            $table->dropForeign(['transfer_reason_id']);
            $table->dropColumn('transfer_reason_id');
            $table->dropForeign(['operation_type_id']);
            $table->dropColumn('operation_type_id');
            $table->dropForeign(['pediment_id']);
            $table->dropColumn('pediment_id');
            $table->dropColumn('origin_certificate');
            $table->dropColumn('number_origin_certificate');
            $table->dropColumn('reliable_exporter_number');
            $table->dropForeign(['incoterm_id']);
            $table->dropColumn('incoterm_id');
            $table->dropColumn('subdivision');
            $table->dropColumn('comment_foreign_trade');
            $table->dropColumn('exchange_rate_usd');
            $table->dropColumn('amount_total_usd');
        });
    }
}
