<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddForeignTradeToCiLineComplements extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customer_invoice_line_complements', function (Blueprint $table) {
            // Campos
            $table->unsignedInteger('tariff_fraction_id')->nullable();
            $table->decimal('customs_quantity',15,5)->default(0);
            $table->unsignedInteger('uom_custom_id')->nullable();
            $table->decimal('price_unit_usd',15,5)->default(0);
            $table->decimal('amount_usd',15,5)->default(0);

            // Foreign
            $table->foreign('tariff_fraction_id')->references('id')->on('tariff_fractions')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('uom_custom_id')->references('id')->on('uom_customs')->onUpdate('cascade')->onDelete('restrict');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customer_invoice_line_complements', function (Blueprint $table) {
            $table->dropForeign(['tariff_fraction_id']);
            $table->dropColumn('tariff_fraction_id');
            $table->dropColumn('customs_quantity');
            $table->dropForeign(['uom_custom_id']);
            $table->dropColumn('uom_custom_id');
            $table->dropColumn('price_unit_usd');
            $table->dropColumn('amount_usd');
        });
    }
}
