<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddForeignTradeToProducts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            // Campos
            $table->unsignedInteger('tariff_fraction_id')->nullable();
            $table->unsignedInteger('uom_custom_id')->nullable();

            // Foreign
            $table->foreign('tariff_fraction_id')->references('id')->on('tariff_fractions')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('uom_custom_id')->references('id')->on('uom_customs')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropForeign(['tariff_fraction_id']);
            $table->dropColumn('tariff_fraction_id');
            $table->dropForeign(['uom_custom_id']);
            $table->dropColumn('uom_custom_id');
        });
    }
}
