<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerQuotationLineTaxesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_quotation_line_taxes', function (Blueprint $table) {
            // Campos
            $table->unsignedInteger('customer_quotation_line_id');
            $table->unsignedInteger('tax_id');

            // Index
            $table->index('customer_quotation_line_id','customer_quotation_line_id','BTREE');
            $table->index('tax_id','tax_id','BTREE');

            // Llave primaria
            $table->primary(['customer_quotation_line_id','tax_id'],'cil_customer_quotation_line_id_tax_id_pk');

            // Foreign
            $table->foreign('customer_quotation_line_id')->references('id')->on('customer_quotation_lines')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('tax_id')->references('id')->on('taxes')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_quotation_line_taxes');
    }
}
