<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->string('name',250);
            $table->string('code',30)->nullable();
            $table->string('taxid',15)->nullable();
            $table->string('curp',50)->nullable();
            $table->string('email',100)->nullable();
            $table->string('phone',100)->nullable();
            $table->string('phone_mobile',100)->nullable();
            $table->unsignedInteger('recruitment_regime_id')->nullable();
            $table->date('date_start_work')->nullable();
            $table->string('nss',50)->nullable();
            $table->boolean('unionized')->default(FALSE);
            $table->unsignedInteger('workday_type_id')->nullable();
            $table->unsignedInteger('contract_type_id')->nullable();
            $table->string('department',100)->nullable();
            $table->string('job',150)->nullable();
            $table->unsignedInteger('job_risk_classe_id')->nullable();
            $table->unsignedInteger('frequency_payment_id')->nullable();
            $table->unsignedInteger('bank_id')->nullable();
            $table->string('bank_account',50)->nullable();
            $table->decimal('base_salary',15,5)->default(0);
            $table->decimal('sdi',15,5)->default(0);
            $table->unsignedInteger('country_id')->nullable();
            $table->unsignedInteger('state_id')->nullable();
            $table->unsignedInteger('company_id')->nullable();
            $table->text('comment')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('recruitment_regime_id')->references('id')->on('recruitment_regimes')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('workday_type_id')->references('id')->on('workday_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('contract_type_id')->references('id')->on('contract_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('job_risk_classe_id')->references('id')->on('job_risk_classes')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('frequency_payment_id')->references('id')->on('frequency_payments')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('bank_id')->references('id')->on('banks')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('country_id')->references('id')->on('countries')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('state_id')->references('id')->on('states')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('company_id')->references('id')->on('companies')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employees');
    }
}
