<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEmployeePayrollLinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employee_payroll_lines', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->unsignedInteger('employee_payroll_id');
            $table->text('name')->nullable();
            $table->string('code')->nullable();
            $table->unsignedInteger('perception_id')->nullable();
            $table->unsignedInteger('deduction_id')->nullable();
            $table->unsignedInteger('other_payment_type_id')->nullable();
            $table->decimal('amount_taxed',15,5)->default(0);
            $table->decimal('amount_exempt',15,5)->default(0);
            $table->decimal('amount_total',15,5)->default(0);
            $table->decimal('amount_caused',15,5)->default(0);
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('employee_payroll_id')->references('id')->on('employee_payrolls')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('perception_id')->references('id')->on('perceptions')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('deduction_id')->references('id')->on('deductions')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('other_payment_type_id')->references('id')->on('other_payment_types')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_payroll_lines');
    }
}
